/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iDate vec4(0.0,0.0,0.0,iGlobalTime)
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(0.2,0.277777)
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

// Deform - square tunnel : REDUX
// Modifications by Stanley Hayes
// Original Created by inigo quilez - iq/2013
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

//Hsv conversion from http://ploobs.com.br/?p=1499

vec3 Hue(float a){
vec3 K = vec3(3,2,1)/3.;
return clamp(abs(fract(vec3(a)+K)*6. - vec3(3.)) - K.xxx, 0., 1.);
}

vec3 HSVtoRGB(vec3 HSV)
{
    return vec3(((Hue(HSV.x) - 1.0) * HSV.y + 1.0) * HSV.z);
}


void main( void )
{
    // normalized coordinates (-1 to 1 vertically)
    vec2 p = (-iResolution.xy + 2.0*gl_FragCoord.xy)/iResolution.y;

    // angle of each pixel to the center of the screen
    
    
    // modified distance metric. Usually distance = (x + y)^(1/2). By replacing all the "2" numbers
    // by 32 in that formula we can create distance metrics other than the euclidean. The higher the
    // exponent, then more square the metric becomes. More information here:
    
    // http://en.wikipedia.org/wiki/Minkowski_distance
    
    float exp = 1.0;
    float crayStationsCoef = 1.01; 
    p.x +=  sin(pow(iGlobalTime,.5))*crayStationsCoef*2.0;
   //p.y +=  cos(iGlobalTime)*crayStationsCoef*10.0;
    float a = atan(p.y,p.x) + iGlobalTime * sin(iGlobalTime)*.002 + iMouse.x * .0001;
    float r = pow( pow(p.x*p.x,exp) + pow(p.y*p.y,exp), 1.0/(exp * 2.0) ) + sin(iGlobalTime)*crayStationsCoef;
    a += pow(r,.50); 
    
       
    // index texture by angle and radious, and animate along radius    
    vec2 uv = vec2( 0.5/r + 0.5*iGlobalTime + iMouse.y,                    a/3.1416 );

    r -= sin(iGlobalTime)*.05;
    // fecth color and darken in the center
    vec3 col =  texture2D( iChannel0, uv ).xyz * r;
    col = HSVtoRGB(vec3(col.r, 1.0, 1.0)); 
	
    col *= (sin(uv.x*5.0)*1.0 + 1.0) * .7;
    
    gl_FragColor = vec4( col, 1.0 );
}
